
/*
 * This routine maps a pad window title bar into a window type.
 * This resource allows the user to set where windows of a particular type
 * will appear on the screen by default by setting the resource:
 *	windowtype*geometry
 * in the user's personal resource database.
 * This database is Sun pi dependent.
 */
static struct namemap {
	char *name;
	char *resource;
} padtypes[] = {
	{ "Pi - ", "pi"},
	{ "Process", "process"},
	{ "Working", "wd"},
	{ "Source Text:", "source"},
	{ "Source Files:", "srcfiles"},
	{ "Help:", "help"},
	{ "Globals:", "globals"},
	{ "Memory:", "memory"},
	{ "Assembler:", "assembler"},
	{ "User Defined Types:", "usertypes"},
	{ "Journal:", "journal"},
	{ "Signals:", "signals"},
	{ "Breakpoint List:", "breakpoint"},
	{ "Rtpi - ", "rtpi"},
	{ "Rtpi:", "rtconnect"},
	{ 0, "frame"},
};

char *padnametoresource(s)
char *s;
{
	struct namemap *np;

	for (np = padtypes; np->name; np++)
		if (!strncmp(np->name, s, strlen(np->name)))
			break;
	return np->resource;	
}
